% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose4-package.R
\docType{package}
\name{xpose4-package}
\alias{xpose4-package}
\alias{xpose}
\title{The Xpose Package}
\description{
Xpose is an R-based model building aid for population analysis using NONMEM. 
It facilitates data set checkout, exploration and visualization, model 
diagnostics, candidate covariate identification and model comparison.
}
\details{
Xpose takes output from NONMEM output and/or PsN output and generates graphs
or other analyses. It is assumed that each NONMEM run can be uniquely
identified by a run number (see section below for how to generate the
appropriate input to Xpose). Xpose is implemented using the lattice graphics
library.

The Xpose package can be divided up into six subsections (functions
associated with each of the different subsections are linked in the "See
Also" section): 
\describe{ 
  \item{Data Functions}{Functions for managing the
         input data and manipulating the Xpose database.} 
  \item{Generic Functions}{Generic wrapper functions around the lattice 
        functions. These functions can be invoked by the user but require quite 
        detailed instructions to generate the desired output.} 
  \item{Specific Functions}{These functions are single purpose functions 
      that generate specific output given only the Xpose database as input. The 
      behavior can, to some extent, be influenced by the user.}
  \item{Classic Functions}{Xpose has a text based menu interface to make it
      simple for the user to invoke the Xpose specific functions. This interface is
      called Xpose Classic. Given the limitations a text based interface imposes,
      Xpose Classic is not very flexible but may be useful for quick assessment of
      a model and for learning to use Xpose.}
  \item{PsN Functions}{These functions are the interface between Xpose and 
      PsN, i.e. they do not post-process NONMEM output but rather PsN output.}
  \item{GAM Functions}{Functions take an Xpose object and performs a generalized additive model
        (GAM) stepwise search for influential covariates on a single model parameter.}
}
}
\section{How to make NONMEM generate input to Xpose}{
 Xpose recognizes NONMEM 
  runs, and files associated to a particular run, though the run number. 
  This is a number that is used in the name of NONMEM model files, output
  files and table files.  The fundamental input to Xpose is one or more
  NONMEM table files.  These table files should be named as below followed by
  the run number, for example xptab1 for run number 1.  Xpose looks for files
  according to the following pattern, where * is your run number:
  
  \bold{sdtab*} Standard table file, containing ID, IDV, DV, PRED, IPRED, 
  WRES, IWRES, RES, IRES, etc.
  
  \bold{patab*} Parameter table, containing model parameters - THETAs, ETAs 
  and EPSes
  
  \bold{catab*} Categorical covariates, e.g. SEX, RACE
  
  \bold{cotab*} Continuous covariates, e.g. WT, AGE
  
  \bold{extra*, mutab*, mytab*, xptab*, cwtab*} Other variables you might
  need to have available to Xpose
  
  \bold{run*.mod} Model specification file
  
  \bold{run*.lst} NONMEM output
  
  Strictly, only one table file is needed for xpose (for example sdtab* or 
  xptab*).  However, using patab*, cotab*, catab* will influence the way that
  Xpose interprets the data and are recommended to get full benefit from 
  Xpose.
  
  You can use code in NONMEM similar to the following to generate the tables 
  you need.  NONMEM automatically appends DV, PRED, WRES and RES unless 
  NOAPPEND is specified.  Don't forget to leave at least one blank line at
  the end of the NONMEM model specification file.
  
  \code{$TABLE ID TIME IPRED IWRES EVID MDV NOPRINT ONEHEADER FILE=sdtab1} 
  \code{$TABLE ID CL V2 KA K SLP KENZ NOPRINT ONEHEADER FILE=patab1} 
  \code{$TABLE ID WT HT AGE BMI PKG NOPRINT ONEHEADER FILE=cotab1} 
  \code{$TABLE ID SEX SMOK ALC NOPRINT ONEHEADER FILE=catab1}
}

\examples{

\dontrun{
# run the classic interface
library(xpose4)
xpose4()
  
# command line interface  
library(xpose4)
xpdb <- xpose.data(5)
basic.gof(xpdb)
}

}
\references{
\href{https://uupharmacometrics.github.io/PsN/}{PsN}
}
\seealso{
Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{change_misc_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{data_extract_or_assign}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{import.variable.definitions}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{par_cov_summary}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{simprazExample}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.data}}, \code{\link{xpose.print}},
  \code{\link{xsubset}}

Other generic functions: \code{\link{gof}},
  \code{\link{xpose.multiple.plot}}

Other specific functions: \code{\link{absval.cwres.vs.cov.bw}},
  \code{\link{absval.cwres.vs.pred.by.cov}},
  \code{\link{absval.cwres.vs.pred}},
  \code{\link{absval.iwres.cwres.vs.ipred.pred}},
  \code{\link{absval.iwres.vs.cov.bw}},
  \code{\link{absval.iwres.vs.idv}},
  \code{\link{absval.iwres.vs.ipred.by.cov}},
  \code{\link{absval.iwres.vs.ipred}},
  \code{\link{absval.iwres.vs.pred}},
  \code{\link{absval.wres.vs.cov.bw}},
  \code{\link{absval.wres.vs.idv}},
  \code{\link{absval.wres.vs.pred.by.cov}},
  \code{\link{absval.wres.vs.pred}},
  \code{\link{absval_delta_vs_cov_model_comp}},
  \code{\link{addit.gof}}, \code{\link{autocorr.cwres}},
  \code{\link{autocorr.iwres}},
  \code{\link{autocorr.wres}}, \code{\link{basic.gof}},
  \code{\link{basic.model.comp}},
  \code{\link{cat.dv.vs.idv.sb}}, \code{\link{cat.pc}},
  \code{\link{cov.splom}}, \code{\link{cwres.dist.hist}},
  \code{\link{cwres.dist.qq}}, \code{\link{cwres.vs.cov}},
  \code{\link{cwres.vs.idv.bw}},
  \code{\link{cwres.vs.idv}},
  \code{\link{cwres.vs.pred.bw}},
  \code{\link{cwres.vs.pred}},
  \code{\link{cwres_wres_vs_x}}, \code{\link{dOFV.vs.cov}},
  \code{\link{dOFV.vs.id}}, \code{\link{dOFV1.vs.dOFV2}},
  \code{\link{data.checkout}},
  \code{\link{dv.preds.vs.idv}}, \code{\link{dv.vs.idv}},
  \code{\link{dv.vs.ipred.by.cov}},
  \code{\link{dv.vs.ipred.by.idv}},
  \code{\link{dv.vs.ipred}},
  \code{\link{dv.vs.pred.by.cov}},
  \code{\link{dv.vs.pred.by.idv}},
  \code{\link{dv.vs.pred.ipred}}, \code{\link{dv.vs.pred}},
  \code{\link{gof}}, \code{\link{ind.plots.cwres.hist}},
  \code{\link{ind.plots.cwres.qq}},
  \code{\link{ind.plots}}, \code{\link{ipred.vs.idv}},
  \code{\link{iwres.dist.hist}},
  \code{\link{iwres.dist.qq}}, \code{\link{iwres.vs.idv}},
  \code{\link{kaplan.plot}}, \code{\link{par_cov_hist}},
  \code{\link{par_cov_qq}}, \code{\link{parm.vs.cov}},
  \code{\link{parm.vs.parm}}, \code{\link{pred.vs.idv}},
  \code{\link{ranpar.vs.cov}}, \code{\link{runsum}},
  \code{\link{wres.dist.hist}}, \code{\link{wres.dist.qq}},
  \code{\link{wres.vs.idv.bw}}, \code{\link{wres.vs.idv}},
  \code{\link{wres.vs.pred.bw}},
  \code{\link{wres.vs.pred}}, \code{\link{xpose.VPC.both}},
  \code{\link{xpose.VPC.categorical}},
  \code{\link{xpose.VPC}}

Other classic functions: \code{\link{xpose4}}

Other PsN functions: \code{\link{boot.hist}},
  \code{\link{bootscm.import}}, \code{\link{npc.coverage}},
  \code{\link{randtest.hist}},
  \code{\link{read.npc.vpc.results}},
  \code{\link{read.vpctab}}, \code{\link{xpose.VPC.both}},
  \code{\link{xpose.VPC.categorical}},
  \code{\link{xpose.VPC}}

Other GAM functions: \code{\link{GAM_summary_and_plot}},
  \code{\link{xp.get.disp}}, \code{\link{xp.scope3}},
  \code{\link{xpose.bootgam}}, \code{\link{xpose.gam}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Justin Wilkins and Andrew Hooker
}
\keyword{methods}
\keyword{package}
