% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwres.dist.hist.R
\name{iwres.dist.hist}
\alias{iwres.dist.hist}
\title{Histogram of individual weighted residuals (IWRES), for Xpose 4}
\usage{
iwres.dist.hist(object, ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{\dots}{Other arguments passed to \code{\link{xpose.plot.histogram}}.}
}
\value{
Returns a histogram of individual weighted residuals (IWRES).
}
\description{
This is a histogram of the distribution of individual weighted residuals
(IWRES) in the dataset, a specific function in Xpose 4. It is a wrapper
encapsulating arguments to the \code{xpose.plot.histogram} function.
}
\details{
Displays a histogram of the individual weighted residuals (IWRES).
}
\examples{
iwres.dist.hist(simpraz.xpdb)

}
\seealso{
\code{\link{xpose.plot.histogram}},
\code{\link{xpose.panel.histogram}}, \code{\link[lattice]{histogram}},
\code{\link{xpose.prefs-class}}, \code{\link{xpose.data-class}}

Other specific functions: \code{\link{absval.cwres.vs.cov.bw}},
  \code{\link{absval.cwres.vs.pred.by.cov}},
  \code{\link{absval.cwres.vs.pred}},
  \code{\link{absval.iwres.cwres.vs.ipred.pred}},
  \code{\link{absval.iwres.vs.cov.bw}},
  \code{\link{absval.iwres.vs.idv}},
  \code{\link{absval.iwres.vs.ipred.by.cov}},
  \code{\link{absval.iwres.vs.ipred}},
  \code{\link{absval.iwres.vs.pred}},
  \code{\link{absval.wres.vs.cov.bw}},
  \code{\link{absval.wres.vs.idv}},
  \code{\link{absval.wres.vs.pred.by.cov}},
  \code{\link{absval.wres.vs.pred}},
  \code{\link{absval_delta_vs_cov_model_comp}},
  \code{\link{addit.gof}}, \code{\link{autocorr.cwres}},
  \code{\link{autocorr.iwres}},
  \code{\link{autocorr.wres}}, \code{\link{basic.gof}},
  \code{\link{basic.model.comp}},
  \code{\link{cat.dv.vs.idv.sb}}, \code{\link{cat.pc}},
  \code{\link{cov.splom}}, \code{\link{cwres.dist.hist}},
  \code{\link{cwres.dist.qq}}, \code{\link{cwres.vs.cov}},
  \code{\link{cwres.vs.idv.bw}},
  \code{\link{cwres.vs.idv}},
  \code{\link{cwres.vs.pred.bw}},
  \code{\link{cwres.vs.pred}},
  \code{\link{cwres_wres_vs_x}}, \code{\link{dOFV.vs.cov}},
  \code{\link{dOFV.vs.id}}, \code{\link{dOFV1.vs.dOFV2}},
  \code{\link{data.checkout}},
  \code{\link{dv.preds.vs.idv}}, \code{\link{dv.vs.idv}},
  \code{\link{dv.vs.ipred.by.cov}},
  \code{\link{dv.vs.ipred.by.idv}},
  \code{\link{dv.vs.ipred}},
  \code{\link{dv.vs.pred.by.cov}},
  \code{\link{dv.vs.pred.by.idv}},
  \code{\link{dv.vs.pred.ipred}}, \code{\link{dv.vs.pred}},
  \code{\link{gof}}, \code{\link{ind.plots.cwres.hist}},
  \code{\link{ind.plots.cwres.qq}},
  \code{\link{ind.plots}}, \code{\link{ipred.vs.idv}},
  \code{\link{iwres.dist.qq}}, \code{\link{iwres.vs.idv}},
  \code{\link{kaplan.plot}}, \code{\link{par_cov_hist}},
  \code{\link{par_cov_qq}}, \code{\link{parm.vs.cov}},
  \code{\link{parm.vs.parm}}, \code{\link{pred.vs.idv}},
  \code{\link{ranpar.vs.cov}}, \code{\link{runsum}},
  \code{\link{wres.dist.hist}}, \code{\link{wres.dist.qq}},
  \code{\link{wres.vs.idv.bw}}, \code{\link{wres.vs.idv}},
  \code{\link{wres.vs.pred.bw}},
  \code{\link{wres.vs.pred}}, \code{\link{xpose.VPC.both}},
  \code{\link{xpose.VPC.categorical}},
  \code{\link{xpose.VPC}}, \code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\keyword{methods}
