% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplified_formals.R
\name{simplified_formals}
\alias{simplified_formals}
\title{Extract and simplify a function's formal arguments}
\usage{
simplified_formals(fn)
}
\arguments{
\item{fn}{\code{Function}.}
}
\value{
A \code{character vector} with the simplified formals.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Extracts \code{\link[base:formals]{formals}} and
formats them as an easily testable \code{character vector}.
}
\examples{
# Attach packages
library(xpectr)

fn1 <- function(a = "x", b = NULL, c = NA, d){
  paste0(a, b, c, d)
}

simplified_formals(fn1)
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
