% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_permtest.R
\docType{class}
\name{permtest-class}
\alias{permtest-class}
\title{Class permtest}
\description{
This class represents the permutation test outcomes. See also
the function \code{\link{permtest}}.
}
\section{Slots}{

\describe{
\item{\code{orig_loss}}{a numeric value with the original loss of
the model.}

\item{\code{perm_losses}}{a numeric vector with the losses of the
different permutations.}

\item{\code{n}}{the number of permutations}

\item{\code{loss_function}}{the function used to calculate the losses.}

\item{\code{exclusion}}{a character value indicating the exclusion
setting used for the test}

\item{\code{replaceby0}}{a locigal value that indicates whether the
exclusion was done by replacing with zero. See also
\code{\link{loo}}.}

\item{\code{permutation}}{a character value that indicats in which
kernel matrices were permuted.}

\item{\code{pval}}{a p value indicating how likely it is to find a
smaller loss than the one of the model based on a normal
approximation.}

\item{\code{exact}}{a logical value indicating whether the P value was
calculated exactly or approximated by the normal distribution.}
}}

\seealso{
\itemize{
\item the function \code{\link{permtest}} for the actual test.
\item the function \code{\link{loo}} for the leave one out
procedures
\item the function \code{\link{t.test}} for the actual test
}
}
