% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body.R
\name{set_wb_widths}
\alias{set_wb_widths}
\title{Set column widths to tab workbook}
\usage{
set_wb_widths(tab, left_header_col_widths = NULL,
  body_header_col_widths = NULL)
}
\arguments{
\item{tab}{The core tab object}

\item{left_header_col_widths}{Width of row header columns you wish to set in Excel column width units. If singular, value is applied to all row header columns. If a vector, vector must have length equal to the number of row headers in workbook. Use special case "auto" for automatic sizing. Default (NULL) leaves column widths unchanged.}

\item{body_header_col_widths}{Width of body header columns you wish to set in Excel column width units. If singular, value is applied to all body columns. If a vector, vector must have length equal to the number of body headers in workbook. Use special case "auto" for automatic sizing. Default (NULL) leaves column widths unchanged.}
}
\description{
Set column widths to tab workbook
}
\examples{
crosstab <- read.csv(system.file("extdata", "example_crosstab.csv", package="xltabr"))
tab <- initialise()
colnames <- c("drive", "age")
tab <- add_body(tab, crosstab, left_header_colnames = colnames)
tab <- set_wb_widths(tab, left_header_col_widths = "auto", body_header_col_widths = c(7,14,28))
}
