% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrades.R
\name{getTrades}
\alias{getTrades}
\title{Returns data on trades.}
\usage{
getTrades(limit, cursor = NULL, order = "asc", domain = "public",
  base_asset_type = "", base_asset_code = "", base_asset_issuer = "",
  counter_asset_type = "", counter_asset_code = "",
  counter_asset_issuer = "", offer_id = "", data.table = FALSE)
}
\arguments{
\item{limit}{numeric - the number of records to return.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{order}{character - optional, "asc" or "desc"}

\item{domain}{- character - signalling to query the testnet or public network. Can be either "testnet" or "public".}

\item{base_asset_type}{optional, string - type of base asset}

\item{base_asset_code}{optional, string - code of base asset, not required if type is native}

\item{base_asset_issuer}{optional, string - issuer of base asset, not required if type is native}

\item{counter_asset_type}{optional, string - type of counter asset}

\item{counter_asset_code}{optional, string - code of counter asset, not required if type is native}

\item{counter_asset_issuer}{optional, string - issuer of counter asset, not required if type is native}

\item{offer_id}{optional, string - filter for by a specific offer id}

\item{data.table}{boolean - if true, a data.table is returned. FALSE by default.}
}
\value{
data.table or list
}
\description{
Return all partially fulfilled trades to buy or sell assets on the ledger.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/trades.html
}
\examples{
\dontrun{getTrades(20)}
}
