% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_all}
\alias{read_all}
\title{Read all text files and concatenate their content}
\usage{
read_all(files, before = function(f) NULL, after = function(f) NULL)
}
\arguments{
\item{files}{A vector of file paths.}

\item{before, after}{A function that takes one file path as the input and
returns values to be added before or after the content of the file.
Alternatively, they can be constant values to be added.}
}
\value{
A character vector.
}
\description{
Read files one by one, and optionally add text before/after the content. Then
combine all content into one character vector.
}
\examples{
# two files in this package
fs = system.file("scripts", c("call-fun.R", "child-pids.sh"), package = "xfun")
xfun::read_all(fs)

# add file paths before file content and an empty line after content
xfun::read_all(fs, before = function(f) paste("#-----", f, "-----"), after = "")

# add constants
xfun::read_all(fs, before = "/*", after = c("*/", ""))
}
