% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{file_ext}
\alias{file_ext}
\alias{sans_ext}
\alias{with_ext}
\title{Manipulate filename extensions}
\usage{
file_ext(x)

sans_ext(x)

with_ext(x, ext)
}
\arguments{
\item{x}{A character of file paths.}

\item{ext}{A vector of new extensions.}
}
\value{
A character vector of the same length as \code{x}.
}
\description{
Functions to obtain (\code{file_ext()}), remove (\code{sans_ext()}), and
change (\code{with_ext()}) extensions in filenames.
}
\details{
\code{file_ext()} is a wrapper of \code{tools::\link{file_ext}()}.
\code{sans_ext()} is a wrapper of \code{tools::\link{file_path_sans_ext}()}.
}
\examples{
library(xfun)
p = c("abc.doc", "def123.tex", "path/to/foo.Rmd")
file_ext(p)
sans_ext(p)
with_ext(p, ".txt")
with_ext(p, c(".ppt", ".sty", ".Rnw"))
with_ext(p, "html")
}
