% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createExclusiveFile.R
\name{createExclusiveFile}
\alias{createExclusiveFile}
\title{Create a unique filename.}
\usage{
createExclusiveFile(fpath = ".", prefix = "data", ext = ".dat")
}
\arguments{
\item{fpath}{File path. Default: ".".}

\item{prefix}{The filename. Default: "data".}

\item{ext}{The file extension. Default: ".dat".}
}
\value{
A filename. Components: 
[prefix]_[year][month][day]_[h][min][sec]_[node]_[pid]_[pad]_[fracsec].[ext]
}
\description{
Name conflicts in filenames are avoided by 
   \itemize{
   \item Including the time fractions below a second (\code{tfrac}).
   \item Padding the name with 6 random letters.
   \item Locking and retrying (as a last resort).
         The program stops after 10 unsuccessful attempts of finding 
         a unique name.
   }
   Created by Jens Kleineheismann (2025).
}
\examples{
tmp<-tempdir()
fn<-createExclusiveFile(fpath=tmp, prefix="data", ext=".dat") 
cat(fn)

}
\concept{File I/O}
