% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtss_time_series.R
\name{time_series}
\alias{time_series}
\title{Get time series}
\usage{
time_series(
  wtss.obj,
  name,
  attributes = NULL,
  longitude,
  latitude,
  start_date = NULL,
  end_date = NULL
)
}
\arguments{
\item{wtss.obj}{Either a WTSS object or a server URL}

\item{name}{Coverage name.}

\item{attributes}{Vector of band names.}

\item{longitude}{Longitude in WGS84 coordinate system.}

\item{latitude}{Latitude in WGS84 coordinate system.}

\item{start_date}{Start date in the format yyyy-mm-dd or yyyy-mm 
depending on the coverage.}

\item{end_date}{End date in the format yyyy-mm-dd or yyyy-mm 
depending on the coverage.}
}
\value{
time series in a tibble format
}
\description{
Retrieves the time series for a pair of coordinates
}
\examples{
{
# connect to a WTSS server
wtss <- wtss::WTSS("http://www.esensing.dpi.inpe.br/wtss/")
# retrieve a time series
ts   <- wtss::time_series(wtss, "MOD13Q1", c("ndvi","evi"), 
                longitude = -45.00, latitude  = -12.00,
                start_date = "2000-02-18", end_date = "2016-12-18")
}
}
\author{
Gilberto Camara
}
