% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/census_geo_api_names.R
\name{census_geo_api_names}
\alias{census_geo_api_names}
\alias{census_geo_api_url}
\title{Census geo API helper functions}
\usage{
census_geo_api_names(
  year = c("2020", "2010", "2000"),
  age = FALSE,
  sex = FALSE
)

census_geo_api_url(year = c("2020", "2010", "2000"))
}
\arguments{
\item{year}{A character object specifying the year of U.S. Census data to be downloaded.
Use \code{"2010"}, or \code{"2020"}. Default is \code{"2020"}.
Warning: 2020 U.S. Census data is downloaded only when \code{\var{age}} and
\code{\var{sex}} are both \code{FALSE}.}

\item{age}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on
age or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Age | Race).
If \code{\var{sex}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}

\item{sex}{A \code{TRUE}/\code{FALSE} object indicating whether to condition on
sex or not. If \code{FALSE} (default), function will return Pr(Geolocation | Race).
If \code{TRUE}, function will return Pr(Geolocation, Sex | Race).
If \code{\var{age}} is also \code{TRUE}, function will return Pr(Geolocation, Age, Sex | Race).}
}
\value{
\describe{
\item{\code{census_geo_api_names()}}{
A named list of \link{character} vectors whose values correspond to columns
of a Census API table and whose names represent the new columns they are
used to calculate in \code{\link[=census_geo_api]{census_geo_api()}}.
}
\item{\code{census_geo_api_url()}}{
A \link{character} string containing the base of the URL to a
Census API table.
}
}
}
\description{
Census geo API helper functions
}
\keyword{internal}
