% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_fit.R
\name{clean_fit_lm}
\alias{clean_fit_lm}
\title{Fit a stats::lm without carying back large structures.}
\usage{
clean_fit_lm(
  outcome,
  variables,
  data,
  ...,
  intercept = TRUE,
  weights = NULL,
  env = baseenv()
)
}
\arguments{
\item{outcome}{character, name of outcome column.}

\item{variables}{character, names of varaible columns.}

\item{data}{data.frame, training data.}

\item{...}{not used, force later arguments to be used by name}

\item{intercept}{logical, if TRUE allow an intercept term.}

\item{weights}{passed to stats::glm()}

\item{env}{environment to work in.}
}
\value{
list(model=model, summary=summary)
}
\description{
Please see \url{https://win-vector.com/2014/05/30/trimming-the-fat-from-glm-models-in-r/} for discussion.
}
\examples{

mk_data_example <- function(k) {
  data.frame(
    x1 = rep(c("a", "a", "b", "b"), k),
    x2 = rep(c(0, 0, 0, 1), k),
    y = rep(1:4, k),
    yC = rep(c(FALSE, TRUE, TRUE, TRUE), k),
    stringsAsFactors = FALSE)
}

res_lm <- clean_fit_lm("y", c("x1", "x2"),
                       mk_data_example(1))
length(serialize(res_lm$model, NULL))

res_lm <- clean_fit_lm("y", c("x1", "x2"),
                       mk_data_example(10000))
length(serialize(res_lm$model, NULL))

predict(res_lm$model,
        newdata = mk_data_example(1))

}
