% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderv.R
\name{orderv}
\alias{orderv}
\title{Order by a list of vectors.}
\usage{
orderv(
  columns,
  ...,
  na.last = TRUE,
  decreasing = FALSE,
  method = c("auto", "shell", "radix")
)
}
\arguments{
\item{columns}{list of atomic columns to order on, can be a \code{data.frame}.}

\item{...}{not used, force later arguments to bind by name.}

\item{na.last}{(passed to \code{\link[base]{order}}) for controlling the treatment of NAs. If TRUE, missing values in the data are put last; if FALSE, they are put first; if NA, they are removed.}

\item{decreasing}{(passed to \code{\link[base]{order}}) logical. Should the sort order be increasing or decreasing? For the "radix" method, this can be a vector of length equal to the number of arguments in \code{...}. For the other methods, it must be length one.}

\item{method}{(passed to \code{\link[base]{order}}) the method to be used: partial matches are allowed. The default ("auto") implies "radix" for short numeric vectors, integer vectors, logical vectors and factors. Otherwise, it implies "shell". For details of methods "shell", "quick", and "radix", see the help for \code{\link[base]{sort}}.}
}
\value{
ordering permutation
}
\description{
Preduce an ordering permutation from a list of vectors.  Essentially a non-\code{...} interface to \code{\link[base]{order}}.
}
\examples{

d <- data.frame(x = c(2, 2, 3, 3, 1, 1), y = 6:1)
d[order(d$x, d$y), , drop = FALSE]
d[orderv(d), , drop = FALSE]

}
\seealso{
\code{\link[base]{order}}, \code{\link{sortv}}
}
