% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnaryFunctions.R
\docType{methods}
\name{ApplyTo}
\alias{ApplyTo}
\alias{ApplyTo,UnaryFnList,UnaryFnList-method}
\alias{ApplyTo,UnaryFnList,UnaryFn-method}
\alias{ApplyTo,UnaryFn,UnaryFnList-method}
\alias{ApplyTo,UnaryFn,UnaryFn-method}
\alias{ApplyTo,UnaryFnList,ANY-method}
\alias{ApplyTo,PartialNamedFn,ANY-method}
\alias{ApplyTo,PartialNamedFn,UnaryFnList-method}
\alias{ApplyTo,PartialNamedFn,UnaryFn-method}
\alias{ApplyTo,PartialFunction,ANY-method}
\alias{ApplyTo,PartialFunction,UnaryFnList-method}
\alias{ApplyTo,PartialFunction,UnaryFn-method}
\alias{ApplyTo,SrcFunction,ANY-method}
\alias{ApplyTo,SrcFunction,UnaryFnList-method}
\alias{ApplyTo,SrcFunction,UnaryFn-method}
\title{Apply a single argument function to its argument.}
\usage{
ApplyTo(f, x, env = parent.frame())

\S4method{ApplyTo}{UnaryFnList,UnaryFnList}(f, x, env = parent.frame())

\S4method{ApplyTo}{UnaryFnList,UnaryFn}(f, x, env = parent.frame())

\S4method{ApplyTo}{UnaryFn,UnaryFnList}(f, x, env = parent.frame())

\S4method{ApplyTo}{UnaryFn,UnaryFn}(f, x, env = parent.frame())

\S4method{ApplyTo}{UnaryFnList,ANY}(f, x, env = parent.frame())

\S4method{ApplyTo}{PartialNamedFn,ANY}(f, x, env = parent.frame())

\S4method{ApplyTo}{PartialNamedFn,UnaryFnList}(f, x,
  env = parent.frame())

\S4method{ApplyTo}{PartialNamedFn,UnaryFn}(f, x, env = parent.frame())

\S4method{ApplyTo}{PartialFunction,ANY}(f, x, env = parent.frame())

\S4method{ApplyTo}{PartialFunction,UnaryFnList}(f, x,
  env = parent.frame())

\S4method{ApplyTo}{PartialFunction,UnaryFn}(f, x, env = parent.frame())

\S4method{ApplyTo}{SrcFunction,ANY}(f, x, env = parent.frame())

\S4method{ApplyTo}{SrcFunction,UnaryFnList}(f, x, env = parent.frame())

\S4method{ApplyTo}{SrcFunction,UnaryFn}(f, x, env = parent.frame())
}
\arguments{
\item{f}{object of S4 class derived from UnaryFn.}

\item{x}{argument.}

\item{env}{environment to work in.}
}
\value{
f(x) if x is not a UnaryFn else f composed with x.
}
\description{
If x is a UnaryFn instance this function returns a new
UnaryFnList representing the composite function c(f, x)
which is interpreted as the function x(f(.)) (composition
from left to right).  Otherwise evaluate f(x) (application
from left to right).
}
