% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifFixedModif.R
\name{identifFixedModif}
\alias{identifFixedModif}
\title{Identify Fixed Modifications}
\usage{
identifFixedModif(
  prot,
  expMass,
  minFragSize = 5,
  maxFragSize = 60,
  indexStart = 1,
  suplPepTab = NULL,
  internFra = TRUE,
  filtChargeCatch = TRUE,
  maxMod = c(p = 3, h = 1, k = 1, o = 1, m = 1, n = 1, u = 1, r = 1, s = 1),
  modTy = NULL,
  specModif = NULL,
  knownMods = NULL,
  identMeas = "ppm",
  limitIdent = 5,
  filtAmbiguous = FALSE,
  recalibrate = FALSE,
  chargeCatchFilter = TRUE,
  massTy = "mono",
  prefFragPat = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{prot}{(character) amino-acid sequene of peptide or protein}

\item{expMass}{(numeric) erperimental masses to identify peptides from}

\item{minFragSize}{(integer) min number of AA residues for considering peptide fragments}

\item{maxFragSize}{(integer) max number of AA residues for considering peptide fragments}

\item{indexStart}{(integer) for starting at correct index (if not 1)}

\item{suplPepTab}{(matrix) additional peptides to be add to theoretical peptides}

\item{internFra}{(logical) decide whether internal fragments should be cosiered}

\item{filtChargeCatch}{(logical) by default removing of all fragments not containing a (polar) charge-cathing residue}

\item{maxMod}{(integer) maximum number of residue modifications to be consiered in fragments (values >1 will increase complexity and RAM consumption)}

\item{modTy}{(character) type of fixed and variable modifications}

\item{specModif}{(list) supplemental custom fixed or variable modifications (eg Zn++ at given residue)}

\item{knownMods}{(character) optional custom alternative to \code{AAfragSettings(ou="all")$knownMods}}

\item{identMeas}{(character) default 'ppm'}

\item{limitIdent}{(character) thershold for identification in 'identMeas' units}

\item{filtAmbiguous}{(logical) allows filtering/removing ambiguous results (ie same mass peptides)}

\item{recalibrate}{(logical or numeric) may be direct recalibration-factor (numeric,length=1), if 'TRUE'  fresh determination of 'recalibFact' or 'FALSE' (no action);  final recalibration-factor used exported in result as $recalibFact}

\item{chargeCatchFilter}{(logical) optionally remove all peptides not containing charge-catch AAs (K, R, H, defined via \code{.chargeCatchingAA()} )}

\item{massTy}{(character) 'mono' or 'average'}

\item{prefFragPat}{(numeric) pattern for preferential fragmentation (see also Haverland 2017), if \code{NULL} default will be taken (in function \code{evalIsoFragm}) from \code{.prefFragPattern()}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages and objects exportet to current session for debugging}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list, ie result of massMatch() on 'pepTab' and 'expMass'
}
\description{
Identify peptide/protein fragment based on experimental m/z values 'expMass' for given range of aa-length.
Internally all possible fragments will be predicted and their mass compared to the experimental values (argument \code{expMass}).
}
\examples{
protP <- c(protP="PEPTIDEKR")
obsMassX <- cbind(a=c(199.1077,296.1605,397.2082,510.2922,625.3192),
  b=c(227.1026,324.1554,425.2031,538.2871,653.3141),
  x=c(729.2937,600.2511,503.1984,402.1507,289.0666),
  y=c(703.3145,574.2719,477.2191,376.1714,263.0874))
rownames(obsMassX) <- c("E","P","T","I","D")       # all 1 & 7 ions not included
identP1 <- identifFixedModif(prot=protP, expMass=as.numeric(obsMassX), minFragSize=2, 
  maxFragSize=7,modTy=list(basMod=c("b","y")))     # looks ok
identP2 <- identifFixedModif(prot=protP, expMass=as.numeric(obsMassX), minFragSize=2, 
 maxFragSize=7, modTy=list(basMod=c("a","x"), varMod=c("h","o","r","m")))
 head(identP1$preMa,n=17)     # predicted masses incl fixed modif
 head(identP2$preMa,n=17)     # predicted masses incl fixed modif 
}
\seealso{
\code{\link{makeFragments}}
}
