% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrbind.R
\name{lrbind}
\alias{lrbind}
\title{rbind on lists}
\usage{
lrbind(lst, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{lst}{(list, composed of multiple matrix or data.frames or simple vectors) main input (each list-element should have same number of columns, numeric vectors will be converted to number of columns of other columns/elements)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
This function returns (depending on input) a matrix or data.frame
}
\description{
rbind-like function to append list-elements containing matrixes (or data.frames) and return one long table. 
All list-elements must have same number of columns (and same types of classes in case of data.frames.
Simple vectors (as list-elements) will be considered as sigle lines for attaching.
}
\examples{
lst1 <- list(matrix(1:9, ncol=3, dimnames=list(letters[1:3],c("AA","BB","CC"))),
  11:13, matrix(51:56, ncol=3))
lrbind(lst1)
}
\seealso{
\code{rbind} in \code{\link[base]{cbind}}
}
