% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_flex_index.R
\name{plot_flex_index}
\alias{plot_flex_index}
\title{Plot a Sample of Working Patterns using Flexibility Index output}
\usage{
plot_flex_index(
  data,
  sig_label = "Signals_sent_",
  method = "sample",
  start_hour = 9,
  end_hour = 17,
  mode = "binary"
)
}
\arguments{
\item{data}{Data frame. Direct data output from \code{flex_index()}.}

\item{sig_label}{Character string for identifying signal labels.}

\item{method}{Character string for determining which plot to return.
Options include "sample", "common", and "time". "sample"
plots a sample of ten working patterns; "common" plots the ten most common
working patterns; "time" plots the Flexibility Index for the group over time.}

\item{start_hour}{See \code{flex_index()}.}

\item{end_hour}{See \code{flex_index()}.}

\item{mode}{See \code{flex_index()}.}
}
\value{
ggplot object. See \code{method}.
}
\description{
This is a helper function for plotting visualizations for the
Flexibility Index using the \code{data} output from \code{flex_index()}. This is used
within \code{flex_index()} itself as an internal function.
}
\examples{
\donttest{
# Pre-calculate Flexibility Index
fi_output <- flex_index(em_data, return = "data")

# Examples of how to test the plotting options individually
# Sample of 10 work patterns
plot_flex_index(fi_output, method = "sample")

# 10 most common work patterns
plot_flex_index(fi_output, method = "common")

# Plot Flexibility Index over time
plot_flex_index(fi_output, method = "time")
}

}
\seealso{
Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Working Patterns}
