% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_network_plot.R
\name{internal_network_plot}
\alias{internal_network_plot}
\title{Plot Internal Network Breadth and Size as a scatter plot}
\usage{
internal_network_plot(
  data,
  hrvar = "Organization",
  mingroup = 5,
  return = "plot",
  bubble_size = c(1, 8)
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{hrvar}{HR Variable by which to split metrics, defaults to
"Organization" but accepts any character vector, e.g. "LevelDesignation"}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group
size. Defaults to 5.}

\item{return}{String specifying what to return. This must be one of the
following strings: - \code{"plot"} - \code{"table"}}

\item{bubble_size}{A numeric vector of length two to specify the size range
of the bubbles}
}
\value{
'ggplot' object showing a bubble plot with internal network size as the
x-axis and internal network breadth as the y-axis. The size of the bubbles
represent the number of unique employees in each group.
}
\description{
Plot the internal network metrics for a HR variable as a scatter plot,
showing Internal Network Breadth as the vertical axis and Internal Network
Size as the horizontal axis.
}
\details{
Uses the metrics \code{Internal_network_size} and
\code{Networking_outside_organization}.
}
\examples{
# Return plot
sq_data \%>\% internal_network_plot(return = "plot")

# Return summary table
sq_data \%>\% internal_network_plot(return = "table")

}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar_asis}()},
\code{\link{create_bar}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_line_asis}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_network_plot}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{mgrrel_matrix}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_rank}()}

Other Network: 
\code{\link{external_network_plot}()},
\code{\link{g2g_data}},
\code{\link{network_describe}()},
\code{\link{network_g2g}()},
\code{\link{network_leiden}()},
\code{\link{network_louvain}()},
\code{\link{network_p2p}()},
\code{\link{p2p_data_sim}()}
}
\concept{Network}
\concept{Visualization}
