% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query-wos.R
\name{query_wos}
\alias{query_wos}
\title{Query the Web of Science}
\usage{
query_wos(query, editions = c("SCI", "SSCI", "AHCI", "ISTP", "ISSHP", "BSCI",
  "BHCI", "IC", "CCR", "ESCI"), sid = auth(Sys.getenv("WOS_USERNAME"),
  Sys.getenv("WOS_PASSWORD")), ...)
}
\arguments{
\item{query}{Query string. See the \href{https://images.webofknowledge.com/images/help/WOK/hs_search_operators.html#dsy863-TRS_search_operator_precedence}{WoS query documentation} page
for details on how to write a query as well as a the list of \href{http://images.webofknowledge.com.ezproxy.lib.vt.edu/WOKRS527R13/help/WOS/hp_advanced_examples.html}{example queries}.}

\item{editions}{Web of Science editions to query. Possible values are listed
\href{http://ipscience-help.thomsonreuters.com/wosWebServicesLite/dbEditionsOptionsGroup/databaseEditionsWos.html}{here}.}

\item{sid}{Session identifier (SID). The default setting is to get a fresh
SID each time you query the WoS, via a call to \code{\link{auth}}. However,
you should try to reuse SID values over multiple queries so that you don't
run into the throttling limits placed on new sessions.}

\item{...}{Arguments passed along to \code{\link[httr]{POST}}.}
}
\value{
An object of class \code{query_result}. This object has the number
of publications that are returned by your query (\code{rec_cnt}), as well as
some info that \code{\link{pull_wos}} uses when it calls \code{query_wos}
internally.
}
\description{
Returns the number of records that match a given query. It's best to call
this function before calling \code{\link{pull_wos}}, so that you know how
many records you are trying to download before you attempt to do so.
}
\examples{
\dontrun{

# Get session ID and reuse it across queries:
sid <- auth("some_username", password = "some_password")

query_wos("TS = (\\"dog welfare\\") AND PY = (1990-2007)", sid = sid)

# Finds records in which Max Planck appears in the address field.
query_wos("AD = Max Planck", sid = sid)

# Finds records in which Max Planck appears in the same address as Mainz
query_wos("AD = (Max Planck SAME Mainz)", sid = sid)
}
}
