% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pip.R
\name{pip_group}
\alias{pip_group}
\title{Return aggregation of PIP statistics}
\source{
\url{https://pip.worldbank.org/api}
}
\usage{
pip_group(
  country = NULL,
  year = NULL,
  povline = 2.15,
  popshare = NULL,
  group_by = c("wb", "none"),
  fill_gaps = FALSE,
  welfare_type = c("all", "consumption", "income"),
  reporting_level = c("all", "national", "rural", "urban"),
  additional_ind = FALSE,
  release_version = NULL,
  ppp_version = NULL,
  version = NULL
)
}
\arguments{
\item{country}{\code{character()} countries for which statistics are to be computed,
specified as ISO3 codes. Default \code{NULL}.}

\item{year}{\code{character()} | \code{numeric()} year(s) for which statistics are to be
computed, specified as YYYY. Default \code{NULL}.}

\item{povline}{\code{numeric(1)} poverty line to be used to compute poverty mesures.
Poverty lines are only accepted up to 3 decimals. Default \code{2.15}.}

\item{popshare}{\code{numeric(1)} proportion of the population living below the poverty
line. Will be ignored if povline is specified. Default \code{NULL}.}

\item{group_by}{\code{character(1)} aggregate results by pre-defined sub-groups.
Default \code{"wb"}.}

\item{fill_gaps}{\code{logical(1)} whether to fill gaps in the data. Default \code{FALSE}.}

\item{welfare_type}{\code{character(1)} type of welfare measure to be used.
Default \code{"all"}.}

\item{reporting_level}{\code{character(1)} level of reporting for the statistics.
Default \code{"all"}.}

\item{additional_ind}{\code{logical(1)} whether to include additional indicators.
Default \code{FALSE}.}

\item{release_version}{\code{character(1)} version of the data release in YYYYMMDD format.
Default \code{NULL}.}

\item{ppp_version}{\code{character(1)} | \code{numeric(1)} version of the data. Default \code{NULL}.}

\item{version}{\code{character(1)} version of the data. Default \code{NULL}.}
}
\value{
A \code{data.frame()} with the requested statistics.
}
\description{
Return aggregation of PIP statistics
}
\examples{
\donttest{
pip_group(c("AFE", "LAC"))
}
}
\seealso{
Other poverty and inequality statistics: 
\code{\link{pip_aux}()},
\code{\link{pip_citation}()},
\code{\link{pip_data}()},
\code{\link{pip_health_check}()},
\code{\link{pip_info}()},
\code{\link{pip_valid_params}()},
\code{\link{pip_versions}()}
}
\concept{poverty and inequality statistics}
