% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_data.R
\name{data_label}
\alias{data_label}
\title{Label factor variables using metadata}
\usage{
data_label(
  x,
  variables = names(x),
  value_labels = read_yaml(paste0("value_labels_", substitute(x), ".yml"))
)
}
\arguments{
\item{x}{A \code{data.frame}.}

\item{variables}{Column names of \code{x} to replace, Default: \code{names(x)}}

\item{value_labels}{A list with value labels, typically read from metadata
generated by \code{\link{open_data}} or \code{\link{closed_data}}.
Default: \code{read_yaml(paste0("value_labels_", substitute(x), ".yml"))}}
}
\value{
A \code{data.frame}.
}
\description{
For each column of \code{x}, this function checks whether value
labels exist in \code{value_labels}. If so, integer values are replaced with these
value labels.
}
\examples{
\dontrun{
if(interactive()){
 labs <- list(x = list(class = "factor", `1` = "a", `2` = "b"))
 df <- data.frame(x = 1:2)
 data_label(df, value_labels = labs)
 }
}
}
