% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimton.R
\name{trimton}
\alias{trimton}
\title{Adjust the amount of turbines per windfarm}
\usage{
trimton(mut, nturb, allparks, nGrids, trimForce, seed)
}
\arguments{
\item{mut}{A binary matrix with the mutated individuals}

\item{nturb}{A numeric value indicating the amount of required turbines}

\item{allparks}{A data.frame consisting of all individuals of the
current generation}

\item{nGrids}{A numeric value indicating the total amount of grid cells}

\item{trimForce}{A boolean value which determines which adjustment
method should be used. TRUE uses a probabilistic approach and
FALSE uses a random approach}

\item{seed}{Set a seed for comparability. Default is NULL}
}
\value{
Returns a binary matrix with the correct amount of turbines
per individual
}
\description{
Adjust the mutated individuals to the required amount of
turbines.
}
\examples{
\donttest{
## Create a random rectangular shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(0, 0), c(0, 2000), c(2000, 2000), c(2000, 0)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
plot(Polygon1,axes=TRUE)

## Create a uniform and unidirectional wind data.frame and plots the
## resulting wind rose
## Uniform wind speed and single wind direction
data.in <- as.data.frame(cbind(ws=12,wd=0))

## Calculate a Grid and an indexed data.frame with coordinates and grid cell Ids.
Grid1 <- GridFilter(shape = Polygon1,resol = 200,prop = 1);
Grid <- Grid1[[1]]
AmountGrids <- nrow(Grid)

startsel <- StartGA(Grid,10,20);
wind <- as.data.frame(cbind(ws=12,wd=0))
wind <- list(wind, probab = 100)
fit <- fitness(selection = startsel,referenceHeight = 100, RotorHeight=100,
              SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,rot=20, dirspeed = wind,
              srtm_crop="",topograp=FALSE,cclRaster="")
allparks <- do.call("rbind",fit);

## SELECTION
## print the amount of Individuals selected.
## Check if the amount of Turbines is as requested.
selec6best <- selection1(fit, Grid,2, T, 6, "VAR");
selec6best <- selection1(fit, Grid,2, T, 6, "FIX");
selec6best <- selection1(fit, Grid,4, F, 6, "FIX");

## CROSSOVER
## u determines the amount of crossover points,
## crossPart determines the method used (Equal/Random),
## uplimit is the maximum allowed permutations
crossOut <- crossover1(selec6best, 2, uplimit = 300, crossPart="RAN");
crossOut <- crossover1(selec6best, 7, uplimit = 500, crossPart="RAN");
crossOut <- crossover1(selec6best, 3, uplimit = 300, crossPart="EQU");

## MUTATION
## Variable Mutation Rate is activated if more than 2 individuals represent
## the current best solution.
mut <- mutation(a = crossOut, p = 0.3);
mut==crossOut

## TRIMTON
## After Crossover and Mutation, the amount of turbines in a windpark change and have to be
## corrected to the required amount of turbines.
mut1 <- trimton(mut = mut, nturb = 10, allparks = allparks, nGrids = AmountGrids,
                trimForce=FALSE)
colSums(mut1)

}
}
\author{
Sebastian Gatscha
}
