% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conTemporal.R
\name{conTemporal}
\alias{conTemporal}
\title{conTemporal}
\usage{
conTemporal(traj, units = "auto")
}
\arguments{
\item{traj}{an object of the class \code{ltraj} which is output from the function \code{conPhase}.}

\item{units}{units of duration e.g., \code{'mins'} (see \code{difftime}).}
}
\value{
A data frame, with the time and duration attributes associated with contact phases.
}
\description{
Create a summary dataframe of the timing and and duration of contact phases.
}
\details{
This function is used to calculate the start and end times of contact phases, and their duration following use of the \code{conPhase} function.
}
\examples{
\dontrun{
data(does)
doecons <- conProcess(does,tc=15*60,dc=50)
doephas <- conPhase(doecons,pc=60*60)
conTemporal(doephas)
}

}
\references{
Long, JA, Webb, SL, Harju, SM, Gee, KL (2022) Analyzing Contacts and Behavior from High Frequency 
 Tracking Data Using the wildlifeDI R Package. \emph{Geographical Analysis}. \bold{54}, 648--663.
}
\seealso{
conPhase
}
\keyword{contacts}
