% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_query.R
\name{wiki_query}
\alias{wiki_query}
\title{Send queries to Wikidata and receive results as dataframe}
\usage{
wiki_query(qry)
}
\arguments{
\item{qry}{A character string representing a SPARQL query to be sent to Wikidata}
}
\value{
A dataframe of results
}
\description{
`wiki_query()` sends a SPARQL query to Wikidata and collects the results in a dataframe
}
\examples{
# List five diseases
query <- 'SELECT ?itemLabel WHERE {
  ?item wdt:P31 wd:Q12136. #instance of disease
  SERVICE wikibase:label { bd:serviceParam wikibase:language "[AUTO_LANGUAGE],en". }
}
LIMIT 5'
wiki_query(query)
}
