% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math_stat_analysis.R
\name{wbt_attribute_correlation_neighbourhood_analysis}
\alias{wbt_attribute_correlation_neighbourhood_analysis}
\title{Attribute correlation neighbourhood analysis}
\usage{
wbt_attribute_correlation_neighbourhood_analysis(
  input,
  field1,
  field2,
  radius = NULL,
  min_points = NULL,
  stat = "pearson",
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input vector file path. See \code{wbt_file_path()} for details.}

\item{field1}{First input field name (dependent variable) in attribute table.}

\item{field2}{Second input field name (independent variable) in attribute table.}

\item{radius}{Search Radius (in map units).}

\item{min_points}{Minimum number of points.}

\item{stat}{Correlation type; one of 'pearson' (default) and 'spearman'.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a correlation on two input vector attributes within a neighbourhood search windows.
}
\keyword{MathandStatsTools}
