% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_segmentation_based_filter}
\alias{wbt_lidar_segmentation_based_filter}
\title{Lidar segmentation based filter}
\usage{
wbt_lidar_segmentation_based_filter(
  input,
  output,
  radius = 5,
  norm_diff = 2,
  maxzdiff = 1,
  classify = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output file.}

\item{radius}{Search Radius.}

\item{norm_diff}{Maximum difference in normal vectors, in degrees.}

\item{maxzdiff}{Maximum difference in elevation (z units) between neighbouring points of the same segment.}

\item{classify}{Classify points as ground (2) or off-ground (1).}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Identifies ground points within LiDAR point clouds using a segmentation based approach.
}
\keyword{LiDARTools}
