% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_rooftop_analysis}
\alias{wbt_lidar_rooftop_analysis}
\title{Lidar rooftop analysis}
\usage{
wbt_lidar_rooftop_analysis(
  buildings,
  output,
  input = NULL,
  radius = 2,
  num_iter = 50,
  num_samples = 10,
  threshold = 0.15,
  model_size = 15,
  max_slope = 65,
  norm_diff = 10,
  azimuth = 180,
  altitude = 30,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{buildings}{Input vector build footprint polygons file.}

\item{output}{Output vector polygon file.}

\item{input}{Input LiDAR file.}

\item{radius}{Search Radius.}

\item{num_iter}{Number of iterations.}

\item{num_samples}{Number of sample points on which to build the model.}

\item{threshold}{Threshold used to determine inlier points (in elevation units).}

\item{model_size}{Acceptable model size, in points.}

\item{max_slope}{Maximum planar slope, in degrees.}

\item{norm_diff}{Maximum difference in normal vectors, in degrees.}

\item{azimuth}{Illumination source azimuth, in degrees.}

\item{altitude}{Illumination source altitude in degrees.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Identifies roof segments in a LiDAR point cloud.
}
\keyword{LiDARTools}
