% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_point_stats}
\alias{wbt_lidar_point_stats}
\title{Lidar point stats}
\usage{
wbt_lidar_point_stats(
  input,
  resolution = 1,
  num_points = TRUE,
  num_pulses = FALSE,
  avg_points_per_pulse = TRUE,
  z_range = FALSE,
  intensity_range = FALSE,
  predom_class = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{resolution}{Output raster's grid resolution.}

\item{num_points}{Flag indicating whether or not to output the number of points (returns) raster.}

\item{num_pulses}{Flag indicating whether or not to output the number of pulses raster.}

\item{avg_points_per_pulse}{Flag indicating whether or not to output the average number of points (returns) per pulse raster.}

\item{z_range}{Flag indicating whether or not to output the elevation range raster.}

\item{intensity_range}{Flag indicating whether or not to output the intensity range raster.}

\item{predom_class}{Flag indicating whether or not to output the predominant classification raster.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates several rasters summarizing the distribution of LAS point data. When the input/output parameters are not specified, the tool works on all LAS files contained within the working directory.
}
\keyword{LiDARTools}
