% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.R
\name{gg_hdrboxplot}
\alias{gg_hdrboxplot}
\title{HDR plot}
\usage{
gg_hdrboxplot(
  data,
  var1,
  var2 = NULL,
  prob = c(0.5, 0.99),
  color = "#00659e",
  scatterplot = FALSE,
  show_lookout = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame or matrix containing the data.}

\item{var1}{The name of the first variable to plot (a bare expression).}

\item{var2}{Optionally, the name of the second variable to plot (a bare expression).}

\item{prob}{A numeric vector specifying the coverage probabilities for the HDRs.}

\item{color}{The base color to use for the mode. Colors for the HDRs are generated
by whitening this color.}

\item{scatterplot}{A logical argument indicating if a regular HDR plot is required
(\code{FALSE}), or if a scatterplot in the same colors is required (\code{TRUE}).}

\item{show_lookout}{A logical argument indicating if the plot should highlight observations with "lookout"
probabilities less than 0.05.}

\item{...}{Other arguments passed to \code{\link[ks]{kde}}.}
}
\value{
A ggplot object showing an HDR plot or scatterplot of the data.
}
\description{
Produces a 1d or 2d box plot of HDR regions. The darker regions
contain observations with higher probability, while the lighter regions contain
points with lower probability. Points outside the largest HDR are shown as
individual points. Points with lookout probabilities
less than 0.05 are optionally shown in red.
}
\details{
The original HDR boxplot proposed by Hyndman (1996), R can be produced with
all arguments set to their defaults other than \code{lookout}.
}
\examples{
df <- data.frame(x = c(rnorm(1000), rnorm(1000, 5, 1)))
df$y <- df$x + rnorm(200, sd=2)
gg_hdrboxplot(df, x)
gg_hdrboxplot(df, x, y, scatterplot = TRUE)
oldfaithful |>
  filter(duration < 7000, waiting < 7000) |>
  gg_hdrboxplot(duration, waiting, scatterplot = TRUE)
cricket_batting |>
  filter(Innings > 20) |>
  gg_hdrboxplot(Average)

}
\references{
Hyndman, R J (1996) Computing and Graphing Highest Density Regions,
\emph{The American Statistician}, \strong{50}(2), 120–126. \url{https://robjhyndman.com/publications/hdr/}
Kandanaarachchi, S & Hyndman, R J (2022) "Leave-one-out kernel density estimates for outlier detection",
\emph{J Computational & Graphical Statistics}, \strong{31}(2), 586-599. \url{https://robjhyndman.com/publications/lookout/}
}
\author{
Rob J Hyndman
}
