% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_quantile}
\alias{predict_quantile}
\title{Prediction of Quantiles for Parametric Lifetime Distributions}
\usage{
predict_quantile(
  p,
  dist_params,
  distribution = c("weibull", "lognormal", "loglogistic", "normal", "logistic", "sev",
    "weibull3", "lognormal3", "loglogistic3")
)
}
\arguments{
\item{p}{A numeric vector of probabilities.}

\item{dist_params}{A (named) numeric vector of (log-)location-scale parameters
in the order of location (\eqn{\mu}) and scale (\eqn{\sigma}). If a
three-parametric model is selected, the threshold parameter (\eqn{\gamma})
has to be the third element.}

\item{distribution}{Supposed distribution of the random variable.}
}
\value{
A vector with predicted quantiles.
}
\description{
This function predicts the quantiles of two- or three-parametric lifetime
distributions that belong to the (log-)location-scale family.
}
\details{
For a given set of parameters and specified probabilities the quantiles
of the chosen model are determined.
}
\examples{
# Example 1 - Predicted quantiles for a two-parameter weibull distribution:
quants_weib2 <- predict_quantile(
  p = c(0.01, 0.1, 0.5),
  dist_params = c(5, 0.5),
  distribution = "weibull"
)

# Example 2 - Predicted quantiles for a three-parameter weibull distribution:
quants_weib3 <- predict_quantile(
  p = c(0.01, 0.1, 0.5),
  dist_params = c(5, 0.5, 10),
  distribution = "weibull3"
)

}
