% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_team.R
\name{wnba_teamyearbyyearstats}
\alias{wnba_teamyearbyyearstats}
\title{\strong{Get WNBA Stats API Team Year by Year Stats}}
\usage{
wnba_teamyearbyyearstats(
  league_id = "10",
  per_mode = "Totals",
  season_type = "Regular Season",
  team_id = "1611661328",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{per_mode}{Per Mode}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{team_id}{Team ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamStats

\strong{TeamStats}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   YEAR \tab character \cr
   GP \tab character \cr
   WINS \tab character \cr
   LOSSES \tab character \cr
   WIN_PCT \tab character \cr
   CONF_RANK \tab character \cr
   DIV_RANK \tab character \cr
   PO_WINS \tab character \cr
   PO_LOSSES \tab character \cr
   CONF_COUNT \tab character \cr
   DIV_COUNT \tab character \cr
   NBA_FINALS_APPEARANCE \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   PF \tab character \cr
   STL \tab character \cr
   TOV \tab character \cr
   BLK \tab character \cr
   PTS \tab character \cr
   PTS_RANK \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Team Year by Year Stats}

\strong{Get WNBA Stats API Team Year by Year Stats}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_teamyearbyyearstats(team_id = '1611661328')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Team Functions: 
\code{\link{wnba_leaguedashteamstats}()},
\code{\link{wnba_teamdashboardbyclutch}()},
\code{\link{wnba_teamdashboardbygamesplits}()},
\code{\link{wnba_teamdashboardbygeneralsplits}()},
\code{\link{wnba_teamdashboardbylastngames}()},
\code{\link{wnba_teamdashboardbyopponent}()},
\code{\link{wnba_teamdashboardbyshootingsplits}()},
\code{\link{wnba_teamdashboardbyteamperformance}()},
\code{\link{wnba_teamdashboardbyyearoveryear}()},
\code{\link{wnba_teamdashlineups}()},
\code{\link{wnba_teamdetails}()},
\code{\link{wnba_teamestimatedmetrics}()},
\code{\link{wnba_teamgamelogs}()},
\code{\link{wnba_teamgamelog}()},
\code{\link{wnba_teamgamestreakfinder}()},
\code{\link{wnba_teamhistoricalleaders}()},
\code{\link{wnba_teaminfocommon}()},
\code{\link{wnba_teamplayerdashboard}()},
\code{\link{wnba_teamplayeronoffdetails}()},
\code{\link{wnba_teamplayeronoffsummary}()},
\code{\link{wnba_teams}()},
\code{\link{wnba_teamvsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Team Functions}
