% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{create_urldummy}
\alias{create_urldummy}
\title{Create an urldummy variable from a data.table object}
\usage{
create_urldummy(wt, dummy, name)
}
\arguments{
\item{wt}{webtrack data object}

\item{dummy}{a vector of urls that should be dummy coded}

\item{name}{name of dummy variable to create.}
}
\value{
webtrack object with the same columns and a new column called "name" including the dummy variable
}
\description{
Create an urldummy variable from a data.table object
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
wt <- extract_domain(wt)
code_urls <- "https://dkr1.ssisurveys.com/tzktsxomta"
create_urldummy(wt, dummy = code_urls, name = "test_dummy")
}
}
