% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{add_next_visit}
\alias{add_next_visit}
\title{Add the next visit as a new column}
\usage{
add_next_visit(wt, level = "url")
}
\arguments{
\item{wt}{webtrack data object.}

\item{level}{character. Either \code{"url"}, \code{"host"} or \code{"domain"}. Defaults to \code{"url"}.}
}
\value{
webtrack data.table with the same columns as wt and
a new column called \code{url_next},\code{host_next} or \code{domain_next}.
}
\description{
\code{add_next_visit()} adds the subsequent visit, as determined by order of
timestamps as a new column. The next visit can be added as either the full URL,
the extracted host or the extracted domain, depending on \code{level}.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# Adding next full URL as new column
wt <- add_next_visit(wt, level = "url")
# Adding next host as new column
wt <- add_next_visit(wt, level = "host")
# Adding next domain as new column
wt <- add_next_visit(wt, level = "domain")
}
}
