% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{trans}
\alias{trans}
\title{Transform Images}
\usage{
trans(
  trans_img = NULL,
  from_img = NULL,
  to_img = NULL,
  shape = 0,
  color = 0,
  texture = 0,
  outname = NULL,
  norm = c("none", "twopoint", "rigid"),
  normpoint = 0:1,
  sample_contours = TRUE,
  warp = c("multiscale", "linear", "multiscalerb")
)
}
\arguments{
\item{trans_img}{list of stimuli to transform}

\item{from_img}{negative transform dimension endpoint (0\% image)}

\item{to_img}{positive transform dimension endpoint (100\% image)}

\item{shape, color, texture}{amount to change along the vector defined by from_img and to_img (can range from -3 to +3)}

\item{outname}{name to save each image as}

\item{norm}{how to normalise the images; see Details}

\item{normpoint}{points for twopoint normalisation}

\item{sample_contours}{whether to sample contours or just points}

\item{warp}{warp type}
}
\value{
list of stimuli with transformed images and templates
}
\description{
Transform a base image in shape, color, and/or texture by the differences between two images.
}
\details{
\subsection{Normalisation options}{
\itemize{
\item none: averages will have all coordinates as the mathematical average of the coordinates in the component templates
\item twopoint: all images are first aligned to the 2 alignment points designated in \code{normpoint}. Their position is set to their position in the first image in stimuli
\item rigid: procrustes aligns all images to the position of the first image in stimuli
}
}

\subsection{Sample contours}{

This interpolates more control points along the lines. This can improve the accuracy of averages and transforms. If you see a “feathery” appearance along lines that have many, close-together points, try turning this off.
}

\subsection{Warp types}{
\itemize{
\item multiscale: Implements multi-scale affine interpolation for image warping. This is the default, with a good balance between speed and accuracy
\item linear: Implements triangulated linear interpolation for image warping. Linear warping is least accurate, often resulting in image artifacts, but is very fast.
\item multiscalerb: Implements multi-scale rigid body interpolation for image warping. This decreases image artifacts in some circumstances, but is much slower.
}
}
}
\examples{
\donttest{
if (webmorph_up()) {
  stimuli <- demo_stim()
  sexdim <- trans(stimuli, stimuli$f_multi, stimuli$m_multi,
                  shape = c(fem = -0.5, masc = 0.5))
  
  sexdim |> draw_tem() |> label()
}
}

}
\seealso{
WebMorph.org functions
\code{\link{avg}()},
\code{\link{continuum}()},
\code{\link{loop}()},
\code{\link{symmetrize}()},
\code{\link{webmorph_up}()}
}
\concept{webmorph}
