% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{gglabel}
\alias{gglabel}
\title{Label with ggplot annotations}
\usage{
gglabel(stimuli, label = TRUE, x = 0.5, y = 0.95, geom = "text", ...)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{label}{a vector of the label text(s) or TRUE to use stimlist names}

\item{x}{x-coordinate for label anchor (left is 0); values <= 1 are interpreted as proportions of width}

\item{y}{y-coordinate for label anchor (bottom is 0); values <= 1 are interpreted as proportions of height}

\item{geom}{the geom to use}

\item{...}{further arguments to pass to \code{\link[ggplot2:annotate]{ggplot2::annotate()}}}
}
\value{
stimlist with labelled images
}
\description{
Label image using \link[ggplot2:annotate]{ggplot2::annotate}. All arguments are vectorised over the stimuli and values are recycled or truncated if there are fewer or more than stimuli.
}
\examples{
stimuli <- demo_stim()

# label with image names
# the default text size in ggplot is tiny
gglabel(stimuli)
\donttest{
# add a watermark
gglabel(stimuli,
        label = "watermark",
        x = 0.5, 
        y = 0.5,
        geom = "text",
        size = 30,
        color = "black",
        angle = -30,
        alpha = 0.5)
}
}
\seealso{
\code{\link[=label]{label()}} for a labeller using syntax like \link[magick:painting]{magick::image_annotate}

Visualisation functions
\code{\link{as_ggplot}()},
\code{\link{draw_tem}()},
\code{\link{label}()},
\code{\link{mlabel}()},
\code{\link{plot.stimlist}()},
\code{\link{plot.stim}()},
\code{\link{plot_rows}()},
\code{\link{plot_stim}()}
}
\concept{viz}
