% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_search_button.R
\name{add_search_button}
\alias{add_search_button}
\title{Add search button to a web map}
\usage{
add_search_button(
  map,
  group,
  property_name = "label",
  zoom = NULL,
  text_placeholder = "Search...",
  open_popup = FALSE,
  position = "topleft"
)
}
\arguments{
\item{map}{'\link{leaflet}'.
Map widget object}

\item{group}{'character' string.
Name of the group whose features will be searched.}

\item{property_name}{'character' string.
Property name used to describe markers, such as, \code{"label"} and \code{"popup"}.}

\item{zoom}{'integer' count.
Zoom level for move to location after marker found in search.}

\item{text_placeholder}{'character' string.
Message to show in search element.}

\item{open_popup}{'logical' flag.
Whether to open the marker popup associated with the searched for marker.}

\item{position}{'character' string.
Position of the button on the web map.
Possible values are \code{"topleft"}, \code{"topright"}, \code{"bottomleft"}, and \code{"bottomright"}.}
}
\value{
A new HTML web \code{map} with added element, an object of class 'leaflet'.
}
\description{
Add a button to a \href{https://leafletjs.com/}{Leaflet} map to search markers/features location by property.
Functionality provided by the \href{https://github.com/stefanocudini/leaflet-search}{leaflet-search}
plugin for Leaflet.
}
\examples{
# create web map and add button to search city names
map <- make_map("Topo") |>
  leaflet::addMarkers(
    lng = ~lng,
    lat = ~lat,
    label = ~name,
    popup = ~name,
    group = "marker",
    data = us_cities
  ) |>
  add_search_button(
    group = "marker",
    zoom = 15,
    text_placeholder = "Search city names..."
  )

# print web map
map
}
\seealso{
\code{\link{make_map}} function for creating a map widget.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
