% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webglobe.R
\name{wgbar}
\alias{wgbar}
\title{Plot bars from the surface}
\usage{
wgbar(lat, lon, alt = 3e+06, colour = "blue", width = 3)
}
\arguments{
\item{lat}{Latitude of the bars' bases, in degrees}

\item{lon}{Latitude of the bars' bases, in degrees}

\item{alt}{Altitude of the bars' tops, may be one or many values}

\item{colour}{Colour of the bars, may be one or many values}

\item{width}{Width of bar bars, may be one or many values}
}
\value{
A webglobe command
}
\description{
Plots bars rising upwards from points on the Earth's surface
}
\examples{
\dontrun{
library(webglobe)
data(quakes)                                                      #Load up some data
wg <- webglobe(immediate=FALSE)                                   #Make a webglobe
wg <- wg + wgbar(quakes$lat, quakes$lon, alt=1.5e6*quakes$mag/10) #Plot quakes
wg <- wg + wgcamcenter(-33.35, 142.96, 8000)                      #Move camera
wg
}

}
