% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_extcompinfo}
\alias{cs_extcompinfo}
\title{Get extended record details by ChemSpider ID}
\usage{
cs_extcompinfo(csid, token, verbose = TRUE, ...)
}
\arguments{
\item{csid}{character,  ChemSpider ID.}

\item{token}{character; security token.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a data.frame with entries: 'csid', 'mf' (molecular formula), 'smiles', 'inchi' (non-standard),
'inchikey' (non-standard), 'average_mass', 'mw' (Molecular weight), 'monoiso_mass' (MonoisotopicMass),
'nominal_mass', 'alogp', 'xlogp', 'common_name' and 'source_url'
}
\description{
Get extended info from Chemspider, see \url{https://www.chemspider.com/}
}
\note{
A security token is neeeded. Please register at RSC
\url{https://www.rsc.org/rsc-id/register}
for a security token.
Please respect the Terms & conditions \url{https://www.rsc.org/help-legal/legal/terms-conditions/}.

use \code{\link{cs_compinfo}} to retrieve standard inchikey.
}
\examples{
\dontrun{
# Fails because no TOKEN is included
token <- '<YOUR-SECURITY-TOKEN>'
csid <- get_csid("Triclosan", token = token)
cs_extcompinfo(csid, token)

csids <- get_csid(c('Aspirin', 'Triclosan'), token = token)
cs_compinfo(csids, token = token)
}
}
\seealso{
\code{\link{get_csid}} to retrieve ChemSpider IDs,
\code{\link{cs_compinfo}} for extended compound information.
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
