% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikidata.R
\name{get_wdid}
\alias{get_wdid}
\title{Get Wikidata Item ID}
\usage{
get_wdid(query, language = "en", first = FALSE, verbose = TRUE)
}
\arguments{
\item{query}{character; The searchterm}

\item{language}{character; the language to search in}

\item{first}{logical; If TRUE return only first result.}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A character vector with the item ID and the additional attribute \code{matched}  (the matched
label).
}
\description{
Get Wikidata Item ID
}
\note{
Only matches in labels are returned.
}
\examples{
\dontrun{
get_wdid('Triclosan', language = 'de')
get_wdid('DDT')
get_wdid('DDT', first = TRUE)

# multiple inpus
comps <- c('Triclosan', 'Glyphosate')
sapply(comps, get_wdid, language = 'en')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

