% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{warp_change}
\alias{warp_change}
\title{Detect changes in a date time vector}
\usage{
warp_change(x, period, every = 1L, origin = NULL)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date time vector.}

\item{period}{\verb{[character(1)]}

A string defining the period to group by. Valid inputs can be roughly
broken into:
\itemize{
\item \code{"year"}, \code{"quarter"}, \code{"month"}, \code{"week"}, \code{"day"}
\item \code{"hour"}, \code{"minute"}, \code{"second"}, \code{"millisecond"}
\item \code{"yweek"}, \code{"mweek"}
\item \code{"yday"}, \code{"mday"}
}}

\item{every}{\verb{[positive integer(1)]}

The number of periods to group together.

For example, if the period was set to \code{"year"} with an every value of \code{2},
then the years 1970 and 1971 would be placed in the same group.}

\item{origin}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

The reference date time value. The default when left as \code{NULL} is the
epoch time of \verb{1970-01-01 00:00:00}, \emph{in the time zone of the index}.

This is generally used to define the anchor time to count from, which is
relevant when the every value is \verb{> 1}.}
}
\value{
A double vector of locations right before a change.
}
\description{
\code{warp_change()} detects changes at the \code{period} level. It returns the
locations of the value just before a change. The location of the last
value in \code{x} is always returned at the end.
}
\examples{
x <- as.Date("2019-01-01") + 0:5

warp_change(x, period = "day", every = 2)

warp_change(x, period = "day", every = 2, origin = as.Date("2019-01-01"))
}
