% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweak_spectro.R
\name{tweak_spectro}
\alias{tweak_spectro}
\title{Plot a mosaic of spectrograms with varying display parameters}
\usage{
tweak_spectro(X, length.out = 5, ovlp = 90, wl = c(100, 1000), wn = "hanning",
 collev.min = -40, pal = "reverse.gray.colors.2", path = NULL, rm.axes = TRUE, ...)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data frame with a single row and columns for sound file name (sound.files), selection number (selec), 
and start and end time of signal (start and end). Default is \code{NULL}.}

\item{length.out}{Numeric vector of length 1 controlling the number of sublevels of
the numeric arguments for which a range has been provided. Ranges are allowed for
'ovlp', 'wl', and 'collev.min' arguments.}

\item{ovlp}{Numeric vector of length 1 or 2 specifying \% of overlap (or 
lower/upper values the desired range) between two consecutive windows, as in 
\code{\link[seewave]{spectro}}. Default is 90.}

\item{wl}{A numeric vector of length 1 or 2 specifying the window length (length 1)
or the lower and upper range limits of the desired window length range (length 2) for creating spectrograms.
Default is c(100, 1000).}

\item{wn}{Character vector specifying the window function names to be used. Several
names can be provided. See \code{\link[seewave]{ftwindow}}
for name options. Default is "hanning". If "all", then all window functions available are used.}

\item{collev.min}{A (negative) numeric vector of length 1 or 2. Determines the first argument
to use in 'collevels' for the internal spectrogram creating function. This replaces the 
first element in the 'collevels' as in \code{\link[seewave]{spectro}}. Note that
'collevels' is not available in this function \code{\link[warbleR]{tweak_spectro}}.}

\item{pal}{Color palette function for spectrogram. Default is "reverse.gray.colors.2". 
Several palettes can be provided in a character vector. Note that, contrary to
 other \code{warbleR} and \code{seewave} functions, the 
palette most be provided as character string rather than as a function. See 
\code{\link[seewave]{spectro}} for more palettes.}

\item{path}{Character string containing the directory path where the sound file are located.}

\item{rm.axes}{Logical. If \code{TRUE} frequency and time axes are excluded. Default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to \code{\link{catalog}} function for customizing
graphical output. Check out \code{\link{catalog}} for more details.}
}
\value{
Image files with spectrograms of entire sound files in the working directory. Multiple pages
can be returned, depending on the length of each sound file.
}
\description{
\code{tweak_spectro} plots a mosaic of spectrograms with varying display parameters to
facilitate selection of display parameters
}
\details{
This functions aims to simplify the selection of spectrogram parameters. 
The function plots, for a single selection, a mosaic of spectrograms with varying 
display parameters. For numeric arguments the upper and lower limits of a range can
be provided. The following arguments accept can have varying values:
\itemize{
   \item \code{wl}: Windows length (numeric range)
   \item \code{ovlp}: Overlap (numeric range)
   \item \code{collev.min}: Minimum value of the color levels (numeric range) 
   \item \code{wn}: window function names (character)
   \item \code{pal}: palette (character)
   }
 Outputs are similar to those of \code{\link{catalog}}. The output image files can be put together in a single pdf file with \code{\link{catalog2pdf}}.
  We recommend using low resolution (~60-100) and smaller dimensions (width & height < 10) if
  aiming to generate pdfs (otherwise pdfs could be pretty big).
}
\examples{
\dontrun{
# Save to temporary working directory

# save sound file examples
data(list = c("Phae.long1", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) 

# variable collevels
tweak_spectro(X = lbh_selec_table, wl = 164, ovlp = c(90), wn = c("flattop"), 
length.out = 16, nrow = 4, ncol = 4, width = 20, height = 11.3, rm.axes = TRUE, 
cex = 1, box = F, collev.min = c(-20, -150), path = tempdir(), flim = c(0, 10))

# variable overlap and wn
tweak_spectro(X = lbh_selec_table, wl = 164, ovlp = c(50, 90), 
wn = c("hanning", "hamming", "rectangle", "bartlett", "blackman", "flattop"),
length.out = 7, nrow = 6, ncol = 7, width = 20, height = 11.3, rm.axes = TRUE, 
cex = 1, box = F, path = tempdir(), flim = c(0, 10))

# variable wl and wn
tweak_spectro(X = lbh_selec_table, wl = c(100, 1000), ovlp = c(50, 90), wn = "all", 
length.out = 5, nrow = 10, ncol = 14, width = 20, height = 11.3, rm.axes = TRUE, 
cex = 0.7, path = tempdir(), flim = c(0, 10))

# variable wl, collev.min and wn 
tweak_spectro(X = lbh_selec_table, wl = c(100, 1000), ovlp = 90, 
wn = c("hanning", "hamming", "rectangle"), collev.min = c(-110, -25), 
length.out = 3, nrow = 10, ncol = 14, width = 20, height = 11.3, rm.axes = TRUE,
 cex = 0.7, path = tempdir(), flim = c(0, 10))
 
 # variable wl, wn and pal
 tweak_spectro(X = lbh_selec_table, wl = c(100, 1000), ovlp = 90, 
 wn = c("hanning", "hamming", "rectangle"), 
 pal = c("reverse.gray.colors.2", "reverse.topo.colors", 
 "reverse.terrain.colors", "reverse.cm.colors"), 
 length.out = 4, nrow = 5, ncol = 10, width = 20, height = 11.3,
  rm.axes = TRUE, cex = 0.7, lab.mar = 2, path = tempdir(), flim = c(0, 10))
  
  # wl, wn and pal
  tweak_spectro(X = lbh_selec_table, wl = c(100, 1000), ovlp = 90,
   wn = c("hanning", "hamming", "rectangle"), 
  pal = c("reverse.gray.colors.2", "reverse.topo.colors", 
  "reverse.terrain.colors", "reverse.cm.colors"), 
  length.out = 4, nrow = 5, ncol = 10, width = 20, height = 11.3, rm.axes = TRUE,
   cex = 0.7, group.tag = "wn",  spec.mar = 0.4, lab.mar = 0.8, box = FALSE, 
   tag.pal = list(reverse.cm.colors), path = tempdir(), flim = c(0, 10))

check this floder
tempdir()
}
}
\seealso{
\code{\link{catalog2pdf}}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
