% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_group.R
\name{update_group}
\alias{update_group}
\title{Update Group}
\usage{
update_group(
  tableau,
  group_id,
  group_name = NULL,
  AD_group_name = NULL,
  AD_domain = NULL,
  minimum_site_role = NULL,
  license_mode = NULL,
  on_demand_access = NULL,
  asJob = FALSE,
  api_version = 3.19
)
}
\arguments{
\item{tableau}{A list containing the Tableau authentication variables: `base_url`, `token`, and `site_id`.}

\item{group_id}{The ID of the group to update.}

\item{group_name}{The new name for the group (optional).}

\item{AD_group_name}{The name of the Active Directory group to synchronize with (optional).}

\item{AD_domain}{The domain for the Active Directory group (optional).}

\item{minimum_site_role}{Required if an import element or grantLicenseMode attribute are present in the request. The site role assigned to users who are imported from Active Directory or granted a license automatically using the grant license on-sync or on-login mode.}

\item{license_mode}{Optional. The mode for automatically applying licenses for group members. When the mode is onLogin, a license is granted for each group member when they log in to a site.}

\item{on_demand_access}{Optional. A boolean value that is used to enable on-demand access for embedded Tableau content when the Tableau Cloud site is licensed with Embedded Analytics usage-based model.}

\item{asJob}{A Boolean value indicating whether to synchronize with Active Directory as a background task (true) or synchronize immediately (false). Default is false.}

\item{api_version}{The API version to use (default: 3.19).}
}
\value{
TRUE if the operation was successful, FALSE otherwise.
}
\description{
Updates a group on a Tableau Server or Tableau Cloud site.
}
\seealso{
Other Tableau REST API: 
\code{\link{add_tags_to_view}()},
\code{\link{add_tags_to_workbook}()},
\code{\link{add_user_to_group}()},
\code{\link{add_user_to_site}()},
\code{\link{authenticate_PAT}()},
\code{\link{authenticate_server}()},
\code{\link{create_group}()},
\code{\link{delete_group}()},
\code{\link{download_datasource}()},
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_crosstab_excel}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_groups_for_user}()},
\code{\link{get_mobile_security_settings}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()},
\code{\link{get_table_assets}()},
\code{\link{get_users_in_group}()},
\code{\link{query_user_on_site}()},
\code{\link{remove_user_from_group}()},
\code{\link{remove_user_from_site}()},
\code{\link{run_extract_refresh_task}()},
\code{\link{update_data_source_now}()},
\code{\link{update_user}()},
\code{\link{update_workbook_now}()}
}
\concept{Tableau REST API}
