% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_user.R
\name{update_user}
\alias{update_user}
\title{Update User}
\usage{
update_user(
  tableau,
  user_id,
  fullName = NULL,
  email = NULL,
  password = NULL,
  siteRole,
  authSetting = NULL,
  api_version = 3.19
)
}
\arguments{
\item{tableau}{A list containing the Tableau authentication variables: `base_url`, `token`, and `site_id`.}

\item{user_id}{The ID of the user to update.}

\item{fullName}{The new name for the user (optional).}

\item{email}{The new email address for the user (optional).}

\item{password}{The new password for the user (optional).}

\item{siteRole}{The new site role to assign to the user.}

\item{authSetting}{The authentication type for the user (optional).}

\item{api_version}{The API version to use (default: 3.19).}
}
\value{
TRUE if the operation was successful, FALSE otherwise.
}
\description{
Modifies information about the specified user.
}
\seealso{
Other Tableau REST API: 
\code{\link{add_tags_to_view}()},
\code{\link{add_tags_to_workbook}()},
\code{\link{add_user_to_group}()},
\code{\link{add_user_to_site}()},
\code{\link{authenticate_server}()},
\code{\link{create_group}()},
\code{\link{download_filtered_tableau_image}()},
\code{\link{download_tableau_crosstab_excel}()},
\code{\link{download_tableau_data}()},
\code{\link{download_workbooks_server_pdf}()},
\code{\link{download_workbooks_server_powerpoint}()},
\code{\link{download_workbooks_server}()},
\code{\link{get_groups_for_user}()},
\code{\link{get_server_connected_apps}()},
\code{\link{get_server_datasources}()},
\code{\link{get_server_groups}()},
\code{\link{get_server_info}()},
\code{\link{get_server_jobs}()},
\code{\link{get_server_projects}()},
\code{\link{get_server_refresh_tasks}()},
\code{\link{get_server_schedules}()},
\code{\link{get_server_user_favorites}()},
\code{\link{get_server_users}()},
\code{\link{get_server_views}()},
\code{\link{get_server_workbooks}()},
\code{\link{get_table_assets}()},
\code{\link{get_users_in_group}()},
\code{\link{query_user_on_site}()},
\code{\link{remove_user_from_group}()},
\code{\link{remove_user_from_site}()},
\code{\link{update_group}()}
}
\concept{Tableau REST API}
