% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_course_file.R
\name{download_course_file}
\alias{download_course_file}
\title{Downloads a file from a given URL.}
\usage{
download_course_file(canvas, file_url, download_path)
}
\arguments{
\item{canvas}{An object containing the Canvas API key and base URL, obtained through the \code{canvas_authenticate} function.}

\item{file_url}{The URL of the file to download.}

\item{download_path}{The path where the file should be downloaded.}
}
\value{
The path of the downloaded file.
}
\description{
This function downloads a file from a specified URL and saves it locally.
}
\examples{
\dontrun{
# Download a file from a given URL
canvas <- canvas_authenticate(api_key, base_url)
file_url <- "https://example.com/file.pdf"
download_path <- "path/to/save/file.pdf"
file_path <- download_course_file(canvas, file_url, download_path)
}
}
