% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VennTable.R
\name{VennTable}
\alias{VennTable}
\title{VennTable}
\usage{
VennTable(x, markdown = FALSE, NAcode = "-", unchecked = c("0",
  "FALSE", "No", "no", "not N/A"), checked = c("1", "TRUE", "Yes", "yes",
  "N/A"))
}
\arguments{
\item{x}{Required: Pattern table produced by \code{vtree} for indicator (i.e 0/1) variables}

\item{markdown}{Format nicely for markdown (see Details).}

\item{NAcode}{Code to use to represent NAs in markdown formatting}

\item{unchecked}{Vector of character strings that represent unchecked values;
by default: c("0","FALSE","No","no","not N/A")}

\item{checked}{Vector of character strings that represent checked values;
by default: c("1","TRUE","Yes","yes","N/A")}
}
\value{
Returns a character matrix with extra rows containing indicator sums.
}
\description{
Given a pattern table produced by \code{vtree} for indicator (i.e 0/1) variables,
\code{VennTable} returns an augmented table.
The augmented table includes an extra row with the total for each indicator variable
and an extra row with the corresponding percentage
(which will not in general add to 100\%).
Also, optionally, does some additional formatting for pandoc markdown.
}
\details{
The column totals ignore missing values.

When \code{markdown=TRUE}, the row and column headings for percentages are 
labeled "\%", indicator values equal to 1 are replaced by checkmark codes,
indicator values equal to 0 are replaced by spaces, and missing indicator
values are replaced by dashes. Empty headings are replaced by spaces.
Finally the table is transposed.
}
\examples{
# Generate a pattern table for the indicator variables Ind1 and Ind2
ptab <- vtree(FakeData,"Ind1 Ind2",ptable=TRUE)
# Augment the table
ptab2 <- VennTable(ptab)
# Print the result without quotation marks (which are distracting)
print(ptab2,quote=FALSE)
# Generate a table with pandoc markdown formatting
ptab3 <- VennTable(ptab,markdown=TRUE)

}
\author{
Nick Barrowman
}
