% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_ctd_ymd}
\alias{vpr_ctd_ymd}
\title{Add Year/ month/ day hour:minute:second information}
\usage{
vpr_ctd_ymd(data, year, offset)
}
\arguments{
\item{data}{VPR data frame from \code{\link{vpr_ctdroi_merge}}}

\item{year}{Year of data collection}

\item{offset}{time offset in hours between VPR CPU and processed data times (optional)}
}
\value{
a VPR data frame with complete date/time information in a new row named 'ymdhms'
}
\description{
Calculate and record calendar dates for vpr data from day-of-year, hour, and time (in milliseconds) info.
Will also add 'avg_hr' parameter if not already present.
}
\examples{
year <- 2019
data('ctd_roi_merge')
dat <- vpr_ctd_ymd(ctd_roi_merge, year)


}
