% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovalmerVoxel.R
\name{anovalmerVoxel}
\alias{anovalmerVoxel}
\title{Computes analysis of variance tables for linear mixed effect model fits on all voxels of a NIfTI image within a mask.}
\usage{
anovalmerVoxel(image, mask, fourdOut = NULL, formula, subjData,
  ddf = "Satterthwaite", type = 3, mc.preschedule = TRUE, ncores = 1,
  ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. Must be a binary mask}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to lmer()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{ddf}{Which approximation of DDF to be used. To be passed to anova.merModLmerTest. Defaults to "Satterthwaite"}

\item{type}{Type of hypothesis to be test (defined from SAS theory). Defaults to 3. To be passed to anova.merModLmerTest}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use}

\item{...}{Additional arguments passed to lmer()}
}
\value{
returns list of models fitted to each voxel over the masked images passed to function.
}
\description{
This function is able to run a Linear Mixed Effect Model using the lmerTest() function and the anova function in that package.
The analysis will run in all voxels in in the mask and will return analysis of variance tables at each voxel.
The function relies on lmerTest to create p-values using the Satterthwaite Approximation. Multi-model calls are disabled.
}
\examples{


image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(c(rep(0,15), rep(1,1)), dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), y = runif(25), id = rep(1:5,5))
fm1 <- "~ x + y + (1|id)"
models <- anovalmerVoxel(image, mask, formula = fm1, subjData = covs, ncores = 1, REML=TRUE)

}

