% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idx.R
\name{add_index}
\alias{add_index}
\title{Calculate the mean value of multiple items}
\usage{
add_index(data, cols, newcol = NULL, clean = TRUE)
}
\arguments{
\item{data}{A dataframe.}

\item{cols}{A tidy selection of item columns.}

\item{newcol}{Name of the index as a character value.
Set to NULL (default) to automatically build a name
from the common column prefix, prefixed with "idx_".}

\item{clean}{Prepare data by \link{data_clean}.}
}
\value{
The input tibble with an additional column that contains the index values.
The column contains the result of the alpha calculation in the attribute named "psych.alpha".
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
ds <- volker::chatgpt
volker::add_index(ds, starts_with("cg_adoption"))
}
