% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.vital}
\alias{autoplot.vital}
\title{Rainbow plot of demographic data against age}
\usage{
\method{autoplot}{vital}(object, .vars = NULL, age = attributes(object)$agevar, ...)
}
\arguments{
\item{object}{A vital including an age variable and the variable you wish to plot.}

\item{.vars}{The name of the variable you wish to plot.}

\item{age}{The name of the age variable. If not supplied, the function will attempt to find it.}

\item{...}{Further arguments not used.}
}
\value{
A ggplot2 object.
}
\description{
Produce rainbow plot (coloured by time index) of demographic variable against
against age.
}
\examples{
autoplot(aus_fertility, Fertility)
}
\references{
Hyndman, Rob J & Shang, Han Lin (2010) Rainbow plots, bagplots,
and boxplots for functional data. \emph{Journal of Computational and Graphical Statistics},
19(1), 29-45. \url{https://robjhyndman.com/publications/rainbow-fda/}
}
\author{
Rob J Hyndman
}
