% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualFields.R
\name{setdefaults}
\alias{setdefaults}
\alias{getnv}
\alias{setnv}
\alias{getgpar}
\alias{setgpar}
\alias{getlocmap}
\alias{setlocmap}
\alias{getlocini}
\alias{setlocini}
\alias{getvfcols}
\title{Settings in the visualField environment}
\usage{
setdefaults()

getnv()

setnv(nv)

getgpar()

setgpar(gpar)

getlocmap()

setlocmap(locmap)

getlocini()

setlocini(locini = 11)

getvfcols()
}
\arguments{
\item{nv}{normative values to to set in the visualFields environment}

\item{gpar}{structure with all graphical parameters}

\item{locmap}{location map to to set in the visualFields environment}

\item{locini}{column from where to start reading the visual field data}
}
\value{
\code{setdefaults}: No return value

\code{getnv}: Returns the normative value currently in used by visualFields

\code{setnv}: No return value

\code{getgpar}: Returns the graphical parameters currently in used by visualFields

\code{setgpar}: No return value

\code{getlocmap}: Returns the location map currently in used by visualFields

\code{setlocmap}: No return value

\code{getlocini}: Returns the column where visual field data starts

\code{setlocini}: No return value

\code{getvfcols}: Returns the columns with visual field data
}
\description{
Functions to set and get settings in the visualField environment
}
\details{
\itemize{
  \item\code{setdefaults} sets the default location map, normative value and
    graphical parameters visualFields environment
  \item\code{setnv} sets normative values in the visualFields environment
  \item\code{getnv} gets current normative values from the visualFields
    environment
  \item\code{setlocmap} sets a location map in the visualFields environment
  \item\code{getlocmap} gets the current location map from the visualFields
    environment
  \item\code{setgpar} sets graphical parameters in the visualFields environment
  \item\code{getgpar} gets current graphical parameters from the visualFields
    environment
  \item\code{setlocini} sets the column where visual field data start in the
    visualFields environment
  \item\code{getlocini} gets the column where visual field data starts from
    the visualFields environment
  \item\code{getlocini} gets the column where visual field data starts from
    the visualFields environment
  \item\code{getvfcols} gets all the columns with visual field data
}
}
\examples{
# get and set normative values
getnv()$info$name                # print name of set normative values
setnv(normvals$iowa_PC26_pw_cps) # set pointwise normative values
getnv()$info$name                # print name of set normative values
setdefaults()                    # return back to defaults
# get and set a location map
getlocmap()$name         # name of set normative values
setlocmap(locmaps$p30d2) # set the 30-2 location map
getlocmap()$name         # name of set normative values
setdefaults()            # return back to defaults
# get and set a graphical parameters
getgpar()$tess$xlim  # limits of x axis
setgpar(gpars$pPeri) # set graphical parameters for the Peripheral test
getgpar()$tess$xlim  # limits of x axis
setdefaults()        # return back to defaults
# get and set initial column for visual field data
getlocini()
getvfcols() # get columns with visual fields data
setlocini(15)
getvfcols() # get columns with visual fields data
setdefaults() # return back to defaults
}
